#include <iostream>
#include <map>
#include <stack>
#include <algorithm>
#include <vector>

using namespace std;

int nadji_rastojanje_ako_je_k_poz(int tr_x, int tr_y, int x2, int y2){
	int x_presecne_tacke = (tr_y - y2 + x2);
	return x_presecne_tacke - tr_x;
}
int nadji_rastojanje_ako_je_k_neg(int tr_x, int tr_y, int x2, int y2){
	int x_presecne_tacke = (x2 + y2 - tr_y);
	return tr_x - x_presecne_tacke;
//	return x_presecne_tacke;
}

struct jarbol{
	int x;
	int y;
	int i;
};

int main(){
	int n;
	cin >> n;
	jarbol niz[n];
	for(int i = 0; i < n; i++){
		cin >> niz[i].x;
		niz[i].i = i; 
	}
	for(int i = 0; i < n; i++){
		cin >> niz[i].y;
	}
	
	sort(niz, niz + n, [](const jarbol& a, const jarbol& b){
		return a.x < b.x;
	});
	
	vector<int> visi_sa_desna(n,-1);
	vector<int> visi_sa_leva(n,-1);
	stack<jarbol> jarboli;
	for(int i = 0; i < n; i++){
		while(!jarboli.empty() and niz[i].y >= jarboli.top().y){
			visi_sa_desna[jarboli.top().i] = nadji_rastojanje_ako_je_k_poz(jarboli.top().x, jarboli.top().y, niz[i].x, niz[i].y);
			jarboli.pop();
		}
		jarboli.push(niz[i]);
	}
	
	stack<jarbol> jarboli1;
	for(int i = n-1; i >= 0; i--){
		while(!jarboli1.empty() and niz[i].y >= jarboli1.top().y){
			visi_sa_leva[jarboli1.top().i] = nadji_rastojanje_ako_je_k_neg(jarboli1.top().x, jarboli1.top().y, niz[i].x, niz[i].y);
			jarboli1.pop();
		}
		jarboli1.push(niz[i]);
	}
	for(auto j : niz){
    	int leva = visi_sa_leva[j.i];
    	int desna = visi_sa_desna[j.i];

    	if(leva == -1) cout << desna << '\n';
    	else if(desna == -1) cout << leva << '\n';
    	else cout << min(leva, desna) << '\n';
	}
	
	return 0;
}